<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Pet extends Model 
{

    protected $table = 'pets';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('Pet', 'user_id');
    }

    public function bookings()
    {
        return $this->hasMany('Booking', 'booking_id');
    }

    public function subscriptions()
    {
        return $this->hasMany('Subscription', 'pet_id');
    }

}